####### ------------------------------------------------------------------------
####### book title: "A crash course on macro-financial crises"
####### authors: Markus K. Brunnermeier and Ricardo Reis 
####### code: Figure 5.2 
####### updated: 07/05/2021
####### code author: Rui Sousa
####### ------------------------------------------------------------------------


################################################################################
#
# INPUT YOUR DIRECTORY HERE (replace X with your directory):
direct <- "C:/Users/zhub11/Dropbox/LSE_Research_Assistant/print queue" #<<<<----
#direct <- "C:/Dropbox/LSE_Research_Assistant/print queue"
#
################################################################################


############## Prepare

#clear environment
rm(list=ls()[ls()!="direct"])

#clear console
cat("\014")

#directory
setwd(direct)

#load and install libraries if needed
#load libraries to be used
packages <- c("dplyr"
			 ,"magrittr"
			 ,"zoo"
			 ,"stringr" 
		   ,"lubridate"
			 ,"scales"
			 ,"readxl"
			 ,"writexl"
			 ,"tidyr"
			 #,"imfr" #imf package # was removed from CRAN in July 2022
			 ,"countrycode")

#install them if needed be
new_packages <-
  packages[!(packages %in% installed.packages()[,"Package"])] 

if (length(new_packages)>0){ #installs them
  install.packages(new_packages, dependencies=TRUE)
}

#activate libraries
lapply(packages, require, character.only = TRUE)


#database id
#imf_ids()
#database_id = "BOP"

#fields
#imf_codelist(database_id="BOP")
#CL_FREQ, CL_INDICATOR_BOP, CL_UNIT_MULT

#imf_codes(codelist = "CL_FREQ"):
#"Q"
#imf_codes(codelist = "CL_UNIT_MULT"):
#6
#imf_codes(codelist = "CL_TIME_FORMAT"):
#"P1D"
#imf_codes(codelist = "CL_INDICATOR_BOP")
#"Financial Account, Net Lending (+) / Net Borrowing (-) (Balance from Financial Account), US Dollars"
#BF_BP6_USD
#"Financial Account, Portfolio Investment, US Dollars"
#BFP_BP6_USD
#"Financial Account, Net Lending (+) / Net Borrowing (-) (Balance from Financial Account), Direct Investment, US Dollars"
#BFD_BP6_USD


############## Download data using API

#list of countries to download
#list derived from S&P's list
#https://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=&ved=2ahUKEwjlofW96JvuAhXgBGMBHfL5BzwQFjAAegQIAhAC&url=https%3A%2F%2Fwww.spglobal.com%2Fspdji%2Fen%2Fdocuments%2Findex-policies%2Fmethodology-country-classification.pdf&usg=AOvVaw2WJ2IlbwSAA4tBzpNJMzxV
data(codelist)
countries <- codelist %>% 
  filter(country.name.en %in% 
           c("Brazil"
             ,"Chile"
             ,"China"
             ,"Colombia"
             #,"Czech Republic"
             ,"Egypt"
             ,"Greece"
             ,"Hungary"
             ,"India"
             ,"Indonesia"
             ,"Malaysia"
             ,"Mexico"
             ,"Pakistan"
             ,"Peru"
             ,"Philippines"
             ,"Poland"
             ,"Qatar"
             ,"Russia"
             ,"Saudi Arabia"
             ,"South Africa"
             #,"Taiwan"
             ,"Thailand"
             ,"Turkey"
             #,"United Arab Emirates"
           )
  )
#countries <- unique(countries$iso2c)
countries <- unique(countries$imf)

# download data
# deprecated since imfr-package was pulled from CRAN
# just download whole data: https://data.imf.org/?sk=7A51304B-6426-40C0-83DD-CA473CA1FD52, using dowmload button on the top right
# unzip and rename to "IMF_BOP"

# df_imf <- imf_data(database_id = "BOP"
#                    ,indicator = c("BF_BP6_USD"
#                                   ,"BFP_BP6_USD"
#                                   ,"BFD_BP6_USD"
#                                   ,"BFF_BP6_USD"
#                    )
#                    , country = countries
#                    , freq = 'Q'
#                    , start = 2005
#                    , end = current_year())

# prepare downloaded data to be in the same format as if API worked
df <- read.csv(paste0(direct, "/IMF_BOP.csv"))
df_imf <- df %>%
  filter(Country.Code %in% countries,
         Indicator.Code %in% c("BF_BP6_USD" ,"BFP_BP6_USD", "BFD_BP6_USD", "BFF_BP6_USD"),
         Attribute == "Value") %>%
  select(!c(tidyselect::contains("Country.Name"), Indicator.Name, Attribute, X)) %>%
  mutate(across(.cols = where(is.character), .fns = function(x) ifelse(x == "", "NA", x)),
         across(.cols = !c(Country.Code, Indicator.Code), as.numeric)) %>%
  pivot_longer(cols = !c(Country.Code, Indicator.Code),
               names_to = "date", values_to = "value") %>%
  pivot_wider(names_from = Indicator.Code, values_from = "value") %>%
  mutate(year_quarter = paste0(substr(date, 2,5), "-", substr(date, 6, 7))) %>%
  # scale down the numbers to be in millions, as in excel
  mutate(across(.cols = where(is.numeric), .fns = function(x) x/1000000)) %>%
  filter(!(is.na(BFD_BP6_USD) & is.na(BFP_BP6_USD)))

  ############## Computations

#compute financial flows
df_plot1 <- df_imf %>% 
  mutate(date = as.Date(
    as.yearqtr(year_quarter,
               format = "%Y-Q%q")
    ,frac = 1
  )) %>%
  filter(year(date)>=2005) %>%
  group_by(date) %>%
  summarize(outflow = -sum(BFP_BP6_USD
                           ,BFD_BP6_USD
                           ,na.rm=TRUE)) %>%
  mutate(flow=outflow-lag(outflow,4))

############## Export .xlsx file

#export data
write_xlsx(df_plot1,"figure8.3_data.xlsx",col_names=TRUE)
